' "The Blade Sentinel"
' Created with QDK 3.1

define game <The Blade Sentinel>
	asl-version <310>
	start <interupt>
	game author <Mihalis "DarkAng3l " Georgostathis>
	game version <0.1>
	game copyright <2002>
	game info < Yes, another superhero game. Blade Sentinel is a creation of my own and not taken from any comic book. Created with QDK 3.1>
	background <green>
	command <open envelope> {
		if got <envelope> then msg < You open the envelope and to your surprise, you reveal a sword's hilt! Who the Hell would have sent you this one.> else msg < You don't have this one.>
		give <hilt>
		lose <envelope>
		hide <envelope>
	}
	command <read newspaper> displaytext <Alpha>
	command <attack #@enemy#> if here <#enemy#> then msg < Don't be so aggressive!> else msg < It is not here.>
end define

define synonyms
end define

define room <interupt>
	script {
		wait <Press key when ready>
		clear
		background <white>
		msg < Sunrays hit your eyes. An alarm clock rings by you. Yes, you have to wake up. Another long day at work waits for you. Better take a shower, get dressed and get to work ASAP.>
		goto <Your bedroom>
		give <blur>
	}
	description msg <>

	define object <blur>
		look msg < Your usual hangover, after spending most of the night working. Have a shower and you will be better.>
		examine exec <look at blur>
		displaytype <feeling>
		drop nowhere <If only it could be possible>
	end define

end define

define room <bathroom>
	south <Your bedroom>
	place <shower>
	description {
		msg < A small bathroom, totally mundane and having everything you would expect.>
		if got <blur> then msg < (Including the shower who will save your life at the moment.)> else msg < (Including the shower that just saved your life some minutes ago.)>
	}
	command <shower> goto <shower>
end define

define room <hall>
	north if got <envelope> or got <hilt> then goto <to work> else msg < Better take this envelope. It might contain something important.>
	south msg < You don't have the time to go to the kitchen. Better hurry. You can have some coffee at work.>
	east <Your bedroom>
	west <sitting room>
	description if not got <folder> then {
		msg < Your hall, a long, narrow room, leading to the north to the exit, to the east to your bedroom and to the south to your kitchen. To the west is a small sitting room.>
		if here <envelope> then msg < Seems like someone has shoved a large yellow envelope under your door.>
	}
	else {
		msg < Well, this morning you left, the house was a mess, but now you have returned, all Hell has broken loose. Seems like someone was searching for something.|n Suddenly, the kitchen door opens and a shade opens the kitchen door. A large humanoid THING. It seems to be one of Torenti's droids.>
		show <droid>
	}
	afterturn override if here <droid> then {
		msg < You feel the world dimming around you, as the droid hits you with the strength of ten men and sends you smash against a wall. You can see your end coming soon, as you land to the floor, the droid standing over you, ready to finish you off.>
		goto <on the floor>
		move <droid; on the floor>
	}

	define object <envelope>
		look msg < A large yellow envelope, containing something solid and somewhat heavy. You notice that the envelope is too thick to fit under the door>
		take {
			msg < You carefully pick up the envelope. It looks like it contains something solid.>
			give <envelope>
		}
		examine msg < By touching thoroughtly the envelope, you get the impression it contains a t-shaped metallic thing.>
		displaytype <item>
		article <it>
		gender <it>
		drop nowhere <Open it first>
	end define

	define object <droid>
		look if got <hilt> then msg < The droid stands right in front of you, its menacing presence filling you with dread. > else msg < The droid stands above you, ready to crush you. Its bulky shape looms above you, your death coming closer moment by moment>
		speak msg < You won't beg for mercy. Especially from a souless thing like it.>
		examine exec <look at droid>
		displaytype <person>
		article <it>
		gender <it>
		hidden
	end define

end define

define room <shower>
	out <bathroom>
	script {
		msg < You enter the shower and poor some cold water on you to wake up. >
		lose <blur>
		hide <blur>
	}
	description msg <>
end define

define room <sitting room>
	east <hall>

	define object <television>
		alt <tv; t.v.; tv set; t.v. set>
		look msg < The television is turned off>
		examine msg < The television is turned off>
		displaytype <object>
		article <it>
		gender <it>
	end define

	define object <couch>
	end define

	define object <desk>
	end define

	define object <computer>
	end define

end define

define room <on the floor>
	script {
		lose <folder>
		lose <hilt>
		move <hilt; on the floor>
	}
	description msg < You are on the floor of your apartment, a menacing droid over you, ready to smash your body. The folder you held has fallen far from your reach and so does your handgun. What is near you is the mysterious hilt you got this morning. Something inside you says it may be your saviour.>
end define

define room <itemroom>

	define object <hilt>
		look msg < Just a sword hilt, made of iron and having a golden dragon carved on it. The blade is missing.>
		take {
			background <red>
			displaytext <transform>
			wait <Press a key to continue>
			background <green>
			displaytext <lab2>
			wait <Press key to continue>
			background <white>
			displaytext <warehouse>
			goto <Outside warehouse>
		}
		examine msg < Just a sword hilt, made of iron and having a golden dragon carved on it. The blade is missing.>
		displaytype <item>
		article <it>
		gender <it>
		drop nowhere <No way...>
	end define

	define object <Jim Wallas>
		alt <Jim; partner; man>
		look msg < A middle aged police detective, medium height but high weight. He is bold, married and has three kids. You are one of the unlucky girls not to have an attractive partner.|n He seems worried about something.>
		speak {
			choose <talkJim>
			msg < |n|n|n|n Tony "the Shark" Torenti, mobster, gundealer, blackmailer etc. Public enemy number one. You managed to find some damning evidence against him last month and the police arrested him. You found it strange he didn't resisted arrest, but you were too drunk with your success you ignored it. Seems that his influence surpasses the law. Evidence disappeared, witnesses changed their testimonies and now he is free. Free like a bird. And you better be careful. This crow holds grunge against you and may attempt to take a vengenge on you.>
			if got <hilt> then msg < As day passes, you find your self puzzled. First, someone shoves a hilt under your door, then an arch- mobster you imprisoned is free and probably out to get you. What the Hell is it going on here?> else msg < As day passes, you find your self puzzled. First, someone shoves a mysterious envelope under your door, then an arch- mobster you imprisoned is free and probably out to get you. What the Hell is it going on here? Perhaps you will find out when you open the envelope. But right now you are too busy.>
			msg < Day turns to night and you are still at your office working on a case. Time to go home. You take a folder with all the necessary paperwork to continue at home.>
			show <folder>
			give <folder>
		}
		examine exec <look at Jim Wallas>
		displaytype <person>
		gender <he>
	end define

	define object <knives>
		look msg < Two throwing knives.>
		take give <knives>
		examine msg < Two throwing knives>
	end define

end define

define room <to work>
	description {
		msg < Alice Morgan... Yeah, that's me! Disciplined police detective, martial arts expert, hardworking, getting the bad guys and not having a personal life at all. And right now being in need for a cup of cofee. And suddering in the idea of another endless day at work.>
		goto <Police department>
	}
end define

define room <Your bedroom>
	north <bathroom>
	west if got <clothes> then goto <hall> else {if got <blur> then msg < Better have a shower and get dressed first.> else msg < Better get dressed first.>}
	description msg < You are in your bedroom. A simple bed occupies the most of the room. To the north is a door leading to the bathroom and to the west, a door to your hall. By the door is a closet, containing your wardrobe.>
	command <turn on tv> msg < You have no time for that.>

	define object <bed>
		look msg <>
	end define

	define object <closet>
		look if not got <clothes> then msg < The closet is open and packed with your clothes.> else msg < The closet is now closed>
		examine exec <look at closet>
		article <it>
		gender <it>
	end define

	define object <clothes>
		look msg < Let me see, work clothes, house clothes, formal clothes, clothes for "special occasions" (You better throw away these ones, they occupy space, you think to yourself.)>
		take {
			if not got <blur> then {
				msg < You put on some clothes and close the closet.>
				give <clothes>
			}
			else msg < Better have a shower first.>
		}
		examine msg < Let me see, work clothes, house clothes, formal clothes, clothes for "special occasions" (You better throw away these ones, they occupy space, you think to yourself.)>
		article <them>
		gender <it>
		drop nowhere <You can't just get naked right here.>
	end define

end define

define room <Police department>
	south if got <folder> then {
		if got <hilt> then {
			msg < Time to go home after another tiring day at work, even though there is work to be done there.>
			goto <hall>
		}
		else msg < Before leaving the police department, you have an urge to open the envelope you got this morning.>
	}
	else msg < Slacking off... you must be asamed.>
	east <your office>
	description msg < As always, the police department is crowded with police officers and minor offenders. The noise is always unbearable as well as  the room itself.|n Things aren't really so bad, since you can go east to your office and you can leave the police department to the south.>
end define

define room <your office>
	west <Police department>
	description {
		msg < A peaceful office, at least compared to the enterance of the department. Two desks are here, one is yours and one belongs to your partner Jim Wallas. Both are packed with any kind of paper a detective could use.>
		if here <newspaper> then msg < A morning newspaper is here. Abnormally, it was published today. The last newspaper you found at the office was five years old.>
		if here <Jim Wallas> then msg < Jim is here, sitting by his desk.>
	}

	define object <newspaper>
		look msg < A morning newspaper.>
		take {
			msg <You take the newspaper.>
			give <newspaper>
			msg <Jim enters the office holding a cup of coffee and goes to his desk.>
			move <Jim Wallas; your office>
		}
		examine msg < The only interesting in the newspaper is the article about Alpha Squad.>
	end define

	define object <your desk>
		look msg < As usually piled with every useless paper you could imagine.>
		examine msg < You search the pile of papers on your desk and reveal the phone number of this guy you liked one and a half years ago. It's not too late to call him now, is it?>
		displaytype <object>
		article <it>
		gender <it>
	end define

	define object <Jim's desk>
		look msg < Not much different from your's, except from a photo of his family on it.>
		examine msg < Jim may be your partner, but this doesn't mean you can search it.>
		displaytype <object>
		article <it>
		gender <it>
	end define

	define object <folder>
		look msg < Another case of murder.>
		take msg < It's too far away to reach it>
		examine msg < You have examined it many times today.>
		displaytype <item>
		article <it>
		gender <it>
		hidden
		drop nowhere < Better take it home.>
	end define

end define

define room <Back alley>
	north if here <tall guard> then msg < You can't go anywhere as long as the guard is here.> else goto <Outside warehouse>
	description {
		msg < A very dark alley, leading to a dead end. The only discernable things here are some garbage bins and better lit street to the north.>
		if here <tall guard> then msg < The tall guard is here, looking for you, ready to fire. Too bad for him he can't see you hiding in the shadows.>
	}
	command <attack bins> {
		msg < You kick one of the garbage bins. Then hide in the dense darkness of the alley and wait for the guards to come. Half a minute later, the tall one is here, searching for the source of the noise>
		move <tall guard; Back alley>
	}
	command <attack garbage bins> exec <attack bins>
	command <attack tall guard> if here <tall guard> then {
		msg < As the guard comes in front of you, you take the oportunity to knock him out with a stunning punch.>
		hide <tall guard>
		conceal <tall guard>
	}
	else msg < He is not here.>
	command <kick bins> exec <attack garbage bins>
	command <kick garbage bins> exec <attack garbage bins>

	define object <garbage bins>
		look msg < Just a few garbage bins.>
	end define

end define

define room <Outside warehouse>
	south <Back alley>
	script {
		lose <hilt>
		lose <clothes>
		give <Blade>
		move <hilt; itemroom>
		move <clothes; itemroom>
	}
	description {
		msg < Down to the docks area, there is a warehouse where "the Shark" stores his "merchentice". Heavy weaponry, enough to arm an entire army.|n And you are outside it, hidden beside a corner. To your south is a dark alley.>
		if here <tall guard> then msg < Unfortunatelly, between you and the door are two guards, a tall and a short one. And they won't roll the red carpet to great you...> else msg < Unfortunatelly, between you and the door is a short guard And he won't roll the red carpet to great you...>
	}
	command <attack tall guard> msg < Even though you can beat them with ease, they will still have time to react. And surprise is an ace in your sleeve.>
	command <attack short guard> if here <tall guard> then msg <  Even though you can beat them with ease, they will still have time to react. And surprise is an ace in your sleeve.> else {
		msg < The nervous short guard is worrying his partner is not coming back. As he looks around for any sign of him, you sneak right behind him and knock him out with one blow. That's what you call a clean job!>
		msg < Now you are free to enter the warehouse. And so you do carefully and silently.>
		goto <warehouse>
	}

	define object <Blade>
		look msg < A blade of raw power is at your hands. The only material part of that sword is its hilt,its origin a mystery.>
		examine msg < A blade of raw power is at your hands. The only material part of that sword is its hilt,its origin a mystery.>
		gender <it>
	end define

	define object <tall guard>
		look msg < A tall guard, dressed as a worker, his Uzi semi-concealed in it. His real occupation is obvious.>
	end define

	define object <short guard>
		look msg < A short guard, dressed as a worker. He looks nervous, his Uzi at hand.>
		displaytype <person>
		gender <he>
	end define

end define

define room <warehouse>
	description msg < The warehouse is empty... except from a douzine of empty crates in a corner, a large crate hanging from a crane and a big mean cyborg with anything than friendly intensions towards you.>
	afterturn msg < The Cyborg smacks you and sends you to the opposite wall. As you smash on it, you feel all the bones of your body protest in a chorus. You don't know how many hits like this you can endure.  >
	command <attack Cyborg> msg < You try to slash the cyborg, but it dodges your blow.>
	command <jump on crate> do <crate>
	command <jump crate> do <crate>

	define object <Cyborg>
		look msg < Not the  bulky piece of (expensive) junk you encoudered (and hacked) an hour ago in your place, but a more bulky, more advansed model, CY-234 Military Mechanical Trooper, is launching at you with full force.>
		speak msg < Yeah, right, talk to it about the weather...>
		examine exec <look at Cyborg>
	end define

	define object <Crate>
		look msg < An enormus crate, hanging over your head. It must weight a ton or something. Probably contains the military equipment Tony Torenti provides his clients with.>
		take msg < It is too heavy for you to lift.>
		examine msg < An enormus crate, hanging over your head. It must weight a ton or something. Probably contains the military equipment Tony Torenti provides his clients with.>
	end define

end define

define room <on crate>
	description msg < Standing on a one ton heavy crate full with high-tech military equipment and a cyborg trying to climb on it to get you, would be a good oportunity to reflect your past life, if you were the heroine of a novel. But since it is real life, you think to yourself, its no time to waste your time, but to act the soonest possible.|n The crate is hanging on an extremely endurable rope. You are on top of it and a Cyborg tries to climb it. Currently only half its torso is over the bottom of the crate. >
	command <cut rope> do <rope>

	define object <rope>
		use <Blade> do <rope>
	end define

end define

define room <dark alley>
	script msg < For the past weeks, you 've been chasing Torenti's goons, capturing most of them. But when Alice heard a tip that Torenti himself would have an important meeting in this specific dark alley, she couldn't resist telling you. So the Blade Sentinel is out to get the big boss. >
	description msg < This dark alley is almost deserted.  Only a man is here, probably waiting for Torrenti. Apart for him, there is nothing of interest here.>
	command <attack man> {
		msg < As you sneak towards the strange man, he turns at you.>
		do <talkSabre>
	}

	define object <man>
		look msg < A man, dressed in a trenchcoat and a hat. You cannot discern much under them.>
		speak do <talkSabre>
		examine exec <look at man>
	end define

end define

define room <control center>
	script {
		msg <|n|n How could I resist such proposal. I managed to sneak into the security center of Torrenti's headquarters. If I went straight at him, his droids would kick my ass. But, here in the control centre, I could set them to full agressive mode, spawning chaos and leaving the path to Torrenti's office clear.>
		set string <fuck; fuck>
	}
	description msg < Security center: Run by Skippy,  real name Samuel Rogers. Single, no girlfriend, a dog named Azor, hobby fishing, Hard worker but using too often explicit language.|n Or so says the folder you got from Sabre. Anyway, the room is but a small office, featuring one desk and one computer.>
	afterturn if property <Skippy's computer; aggr=true> then msg < A man voice says: "Hey Skippy, will you open for me?">

	define object <Skippy's desk>
	end define

	define object <Skippy's computer>
		alt <computer>
		look if property <Skippy's computer; password=true> then msg < The computer is on and ready for use.> else msg < The computer is set in a login screen waiting for a password.>
		take if property <Skippy's computer; password=false> then {
			msg < The computer asks for a password>
			enter <password>
			if ( #password# = #fuck# ) then {
				msg < The password is correct.>
				property <Skippy's computer; password=true>
			}
			else msg < The password is incorrect.>
		}
		else choose <computer>
		examine exec <look at computer>
		gender <it>
		use if not real <password> then {
			msg < The computer asks for a password>
			enter <#password#>
			if ( #password# = #fuck# ) then {
				msg < The password is correct.>
				property <Skippy's computer; password=true>
			}
			else msg < The password is incorrect.>
		}
		else choose <computer>
		properties <password=false; aggr=false>
	end define

end define

define room <flags>

	define object <password>
		hidden
	end define

end define

define room <Outside Torenti's office>
	north <Torenti's office>
	script msg <|n As you sneak to your target, you can hear the havoc caused by your little trick. Screams of panic and machinegun fires sound all over the building. Some explosions can be heard sporadicly, indicating things are getting too wild. And you smile as you imagine the faces of those trying to reset the droids to normal behaviour, when they find out the computer's screen is broken.>
	description msg < You have reached your goal. Your rival's office is ahead of you, to the north.>
end define

define room <Torenti's office>
	script msg < As you enter the office, you instantly notice Torrenti and one of his goons. Torrenti imediatly stands up and enters a hidden door behind his office. The goon pulls out his pistol and aims at you. Time for action now.>
	description {
		msg < The room is a luxurious office, as you would expect from a powerful criminal like Torenti. To the north of the room is a big desk, from which the mobster controlled his crime empire. Expensive painting hang from the walls. A bookcase covers the entire west wall.>
		if here <goon> then msg < One of Torenti's goons is here, aiming at you with his gun.>
	}
	command <attack goon> if here <goon> then {
		msg < The bulky man takes an expression of surprise and dread, as your blade cuts his gun in two. Then, a spinning kick knocks him out. >
		move <goon; itemroom>
	}

	define object <goon>
	end define

	define object <Torenti's desk>
		look if here <goon> then msg < The desk is big. That's the only thing you care about at the moment, since a gun is aiming at your head.> else {
			msg < Looking closer at the office, you cannot but notice that there is a button on it. You press it and a secret door opens behind the desk. The secret door Torenti used to leave the office.>
			create exit north <Torenti's office; Escaping room>
		}
	end define

	define object <library>
	end define

end define

define room <Secret room>

	define object <katana>
		look msg < A long, curved sword with a razor sharp edge.>
		take give <katana>
		examine msg < The blade has a dragon carved on it.>
		displaytype <sword>
		gender <it>
	end define

	define object <Rapier>
		look msg < A flexible, long sword with a handgrip made to protect the hand. The edge is too blunt to cut anything. with it. It is used for impaling foes.>
		take give <Rapier>
		examine msg < A crown is carved on the handgrip.>
		displaytype <sword>
		gender <it>
	end define

	define object <Scimitar>
		look msg < A curved broad sword. >
		take give <Scimitar>
		examine msg < A curved broad sword.>
	end define

	define object <gladius>
		look msg < A short sword. It has the usual sword shape.>
		take give <gladius>
		examine msg < A short sword. It has the usual sword shape.>
	end define

	define object <Claymore>
		look msg < A long sword. It has the usual sword shape.>
		take give <Claymore>
		examine msg < A short sword. It has the usual sword shape.>
		displaytype <sword>
		gender <it>
	end define

	define object <Samurai>
		look msg < A statue of a japanese warrior.>
		examine msg < A statue of a japanese warrior.>
		displaytype <statue>
		gender <it>
	end define

	define object <Legionare>
		look msg < An ancient roman soldier.>
		examine msg < An ancient roman soldier.>
		displaytype <statue>
		gender <it>
	end define

	define object <Muscetier>
		look msg < The statue of a musceteer. He reminds you of the Alexander Dumas novels you have read when you were younger.>
		examine msg < The statue of a musceteer. He reminds you of the Alexander Dumas novels you have read when you were younger.>
		displaytype <statue>
		gender <it>
	end define

	define object <Arab>
		look msg < A statue of an Arab man, with his arm raised on the air, ready to strike.>
		examine msg < A statue of an Arab man, with his arm raised on the air, ready to strike.>
	end define

	define object <Scotsman>
		look msg < A scotish clansman. Easily recognisable by his quilt.>
		examine msg < A scotish clansman. Easily recognisable by his quilt.>
	end define

end define

define room <Garden>
	south <Gate>
	description msg < As far as the eye sees, a delightfull green surrounds you. The only exception is to the south, where a tall wall stands. A big golden  gate is on it. Perhaps a way out from here... or further inside...>
end define

define room <Gate>
	north <Garden>
	description msg < You are standing next to a tall wall. A golden gate is in front of you. You can always back away to an infinite garden to the north.|n The gate is locked.>
	command <press #vitrue#> do <vitrues>

	define object <Golden Gate>
		look msg < A shiny golden gate. It is an embosed sword on it. It's blade is pointing to the sky and vines surround it. At the height of your torso is a panel.>
		examine msg < A shiny golden gate. It is an embosed sword on it. It's blade is pointing to the sky and vines surround it. At the height of your torso is a panel.>
	end define

	define object <panel>
		look msg < On the hilt of the embossed sword is a small round pannel. It has five buttons, named "Valor", "Justice", "Honour", "Compassion", "Strength". A small plaque admist them says: "Priority of virtues shall unseal the passage". >
		examine msg < On the hilt of the embossed sword is a small round pannel. It has five buttons, named "Valor", "Justice", "Honour", "Compassion", "Strength". A small plaque admist them says: "Priority of virtues shall unseal the passage". >
	end define

end define

define room <Castle>
	description msg < Behind the golden gate is a castle of stunning beauty. It is made of bright white stone, its high towers almost piercing the sky.|n Next to you is a fountain. It has a statue of a knight. Many birds come doen by it and drink some water.|n It is like the dreams you had when you were a little girl. Are you still in a dream or...>

	define object <fountain>
		look msg < A fountain made of black marble. The water pours from the mouths of statue dragons. In the middle of it is a large statue. The statue depicts a knight.>
		examine msg < A fountain made of black marble. The water pours from the mouths of statue dragons. In the middle of it is a large statue. The statue depicts a knight.>
	end define

	define object <Statue>
		look do <statue>
		examine do <statue>
	end define

end define

define room <Surgery (on table)>
	script msg < Back to reality, you are ready to do your duty. As long as you get up and stop this crippling pain.>
	description msg < You are in a surgury room. Some bright light shine above you, blinding you.|n A doctor is here by you, preparing an injection. >
	command <attack doctor> {
		msg < You take a deep breath, as you grasp the hand of the doctor and stab his other hand with the syrinx. The doctor screams and so are you. Your whole body aches from the effort you have put to move. With double effort you manage to get up and stand to your feet.|nSuddenly the door slams open and a female figure enters, wearing a tight black costume: Vixen!|n You focus on the Blade real hard. For a moment you forget about  your pain, Vixen, the rest of the bastards of Alpha force, Torrenti, Alice. You think of the Blade. And here it is, a sword of pure energy, filling you with power to surpass your pain and fight on.>
		give <Blade>
		goto <Surgery>
	}

	define object <Doctor>
		look msg < A man in his early forties. Has black hair and dressed in a white robe. He is prepering to do you an injection... not one good for your health you suppose.>
		speak msg < You try to utter a word, but you feel too weak. Better hold your powers for what necessary.>
		examine msg < A man in his early forties. Has black hair and dressed in a white robe. He is prepering to do you an injection... not one good for your health you suppose.>
		displaytype <person>
		gender <he>
	end define

end define

define room <Surgery>
	west if here <Vixen> then msg < You cannot, since Vixen blocks your way.> else {if here <The Crusader> and property <The Crusader; active=true> then msg < As you try to exit the room, a bolt from Crusader's fists sents you smashing against the wall.> else goto <Hallway>}
	description {
		msg < A surgery room, somewhere in the headquarters of Alpha Force. The room is a bit... disturbed, after the good doctor you stabbed with a syrinx fell on a shelf and dropped all over the room its contents.|n Offcourse, there is allways a way out to the west.>
		if here <Vixen> then msg < Vixen from Alpha force is here. And she doesn't want the two of you to chat... >
		if here <The Crusader> then {if property <The Crusader; active=true> then msg < The Crusader is here, ready to preach him the "not messing with the chosen of a magical artifact" dogma.> else msg < The Cruseder is here unconsious, his hands nailed to the wall, a mockery of the Crusifix.>}
	}
	command <attack Vixen> {
		msg < With a thundering kick, you manage to send Vixen unconsious,her body lands next to the doctor's. Way a superhero. She is not a worthy oponent for you.|n|n Her knives fall on the ground, spinning for a while, before stoping in front of your feet.>
		move <Vixen; itemroom>
		move <knives; Surgery>
	}

	define object <Vixen>
		look msg < A woman with a slim, athletic body, wearing a cheesy black and purple super-hero suit. Half her face was covered with a mask of the same colours. Her hands play with a pair of throwing knives, her trademark.>
		speak msg < Better talk to her in kicks.>
		examine exec <look at Vixen>
	end define

end define

define room <Hallway>
	north if here <The Crusader> and property <The Crusader; active=true> then msg < As you try to exit the room, a bolt from Crusader's fists sents you smashing against the wall.> else goto <Training room>
	east if here <The Crusader> and property <The Crusader; active=true> then {
		goto <Surgery>
		move <The Crusader; Surgery>
	}
	west if here <The Crusader> and property <The Crusader; active=true> then msg < As you try to exit the room, a bolt from Crusader's fists sents you smashing against the wall.> else {if got <key card> then goto <Headquarters> else msg < The door is locked.>}
	script if property <The Crusader; active=true> then msg < You barge in a hallway and you spot The Crusader preying God to help him with the Rubic's cube he is trying to solve. The good thing is he didn't surprised you. The bad thing is that he spotted you too. So he drops the cube and stands up to face you.>
	description {
		msg < A hallway in the base of Alpha Force. To the East is a surgery, to the North the training room and to the West the headquarters of the base. >
		if here <The Crusader> then {if property <The Crusader; active=true> then msg < The Crusader is here, ready to preach him the "not messing with the chosen of a magical artifact" dogma.> else msg < The Cruseder is here unconsious, his hands nailed to the wall, a mockery of the Crusifix.>}
	}

	define object <The Crusader>
		look if property <The Crusader; active=true> then msg < The Crusade, one of the least popular Alpha Force's members, due to his religious fanatism. This guy wears a suit full of crosses and constantly talks about the wrath of God falling upon the sinners. But surely the energy bolt throwers on his wrists won't allow his enemies to think he is a jester.> else msg < The Crusader should be renamed as 'The Crusifix' after you took care of him. His hands are nailed to the wall, a throwing knife in each one. His arms form a V-shape. His head is leaning to the left side, suffering is drawn on his face.>
		speak msg < "Go to Heaven!" would be a good punchline for this freak, but there is no time for words.>
		examine exec <look at The Crusader>
		use <knives> {
			msg < You throw one of the knives towards the Crusader, stabing one of his hands and nailing it on a wall. Then you do the same with the other knife to the other hand, having him immobilised. A good kick is what is left to sent him knocked out. His body drops, giving you an impression of watching the Crusifix in a superhero costume, with ridiculus colours, full of crosses.>
			property <The Crusader; active=false>
		}
		properties <active=true>
	end define

	define object <Rubic's cube>
		look msg < A Rubic's cube, a cube consisted of smaller blocks of different colours. These blocks can be turned around. The perpose of it's existance is to play with it. You win if you manage to have one colour in each surface of the cube.>
		take give <Rubic's cube>
		examine exec <look at Rubic's cube>
	end define

end define

define room <Training room>
	south <Hallway>
	west if property <Rock hard; cube=false> then msg < Rock Hard blocks your path.> else {
		msg < You sneak to the observatory, while Rock Hard desperately tries to solve the Rubic's cube you gave him.>
		goto <Observatory>
	}
	description {
		msg < A training room for the members of Alpha Force. It has target, practise dummies and some cyborgs, used for moving target enemies.>
		msg < An observatory is to the West.>
		if property <Rock hard; cube=false> then msg < Rock Hard is here.> else msg < Rock Hard is here, trying to solve a Rubic's cube.>
	}
	command <attack Rock hard> msg < Not a good idea. He could smash you with one hand.>

	define object <Rock hard>
		look msg < A bulk of muscles, known for his trementous strength.>
		speak if property <Rock hard; cube=false> then msg < -Why don't you let me pass to the Observatory.|n -Because Sabre told me not to, and not to obey orders, for I am an idiot, but I am clever and I can prove it.> else msg < He is so focused on solving the cube, that he won't listen to you.>
		examine exec <look at Rock hard>
		use <Rubic's cube> {
			msg < - Here, prove me you are clever and I will go, you say to the bulky avenger, as you pass him on the Rubic's cube. He grabs it and tries to solve it. |nToo bad for him, he will take him years to do it. And he is so focused on solving the Rubic's cube that he will fail to comprehent what goes on around him for this time. >
			property <Rock hard; cube=true>
		}
		properties <cube=false>
	end define

end define

define room <Observatory>
	script if here <Sabre> then msg < Now you are face to face with Sabre. He looks surprised to see you, but he extracts his trademark sabre and attacks you.>
	description {
		if here <Sabre> then msg < A narrow room, used both for instructing the practicing Alpha Force members and for maintaining the training instruments. To the East is big glass window and by it, a panel used for controling the various training instruments. To the west wall, are shelves, holding bottles and tools. An exit to the East leads to the Training room.|n Sabre is here, fighting you.> else msg < A narrow room, used both for instructing the practicing Alpha Force members and for maintaining the training instruments. To the East is big glass window and by it, a panel used for controling the various training instruments. To the west wall, are shelves, holding bottles and tools. An exit to the East leads to the Training room.|n You can see a lake of grease on the ground, as a result of the falling of some bottles. >
		if here <key card> then msg < A red key card is on a table.>
	}

	define object <Sabre>
		look msg < Sabre, a man dressed in a dark  red costume and holding a sabre is fighting with you.>
		speak msg < You are going to pay for this, Sabre, you hiss to him, as you dodge his strike.>
		examine exec <look at Sabre>
		displaytype <person>
		gender <he>
	end define

	define object <key card>
		look msg < A red key card.>
		take if here <Sabre> then msg < You try to take the key card, but the swinging sabre of Sabre makes you think twice about it.> else give <key card>
		examine msg < A red key card>
	end define

	define object <Bottles>
		look msg < A set of bottles on a nearby shelf. Their labels indicate they are used for the maintenance of the practice cyborgs.>
		take {
			msg < As you try to reach the bottles, you drop some of them. The result: Broken glasses everywhere and a lake of grease on the floor. Quickly, you try to take another bottle and throw it at Sabre's fet. On second attempt you suceed it. Your rival, as hard as he may try, cannot keep his balance, and falls down. He hits his head on a table and falls unconcious.>
			move <Sabre; itemroom>
			move <Bottles; itemroom>
		}
		examine msg < A set of bottles on a nearby shelf. Their labels indicate they are used for the maintenance of the practice cyborgs.>
	end define

end define

define room <Headquarters>
	script msg < What a surprise! Torrenti is here, in the base of |n As you enter the room, you feel your powers leaving you. After all the fights you gave, you cannot take much more. You fall to your knees, as Torrenti comes above you.>
	description msg < A large room, used by the members of Alpha Force as headquarters. Right now it only has two people in it: You, the avenger Blade Sentinel, and Tony "The Shark" Torrenti, public one mobster in the city.|n In the center of the room, there is a big round table and some chairs around it. You are by the door, your back against the wall, by an alarm button. >
	beforeturn msg < You feel as time has frozen. Those few instances seem to you like a century.>
	command <attack Torrenti> msg < You don't have the strength to.>
	command <press alarm button> playerwin
	command <press alarm> playerwin
	command <ring alarm> playerwin

	define object <Torrenti>
		look msg < A fat man in his early 50's, dressed in a well tailored suit, holding a revolver an inch from your face.>
		speak msg < No more words to say to him.>
		examine exec <look at Torrenti>
	end define

	define object <alarm button>
		look msg < A red  button writing alarm on it.>
		take playerwin
		examine msg < A red button writing alarm on it.>
		displaytype <button>
		gender <it>
	end define

end define

define room <Escaping room>
	description msg < You descend the stairs and reach to a tunel. There seems to have been an escape pad here. The only thing you see at the moment is a note.>

	define object <note>
		look {
			msg < The note reads: "Bye bye Blade Sentinel!".>
			lose <Blade>
			lose <newspaper>
			displaytext <boom>
			wait <press a key to continue>
			displaytext <wake>
			wait <Press a key to continue>
			goto <Garden>
		}
		take exec <look at note>
		examine exec <look at note>
	end define

end define

define procedure <crate>
	msg < You gather your strength and you jump high enough to grab the bottom of the crate. You hastily climb on it, as the cyborg tries to grab your leg. It fails and tries to climb on the crate too. But due to its high weight, it will take it some more time.>
	move <Cyborg; on crate>
	goto <on crate>
	
end define

define procedure <rope>
	msg < You know what to do. As endurable as this rope may be, your blade is too sharp for it. With one slash, you cut it in two. The crate, free from its holding, falls, the cyborg trapped underneath it. A crushing sound indicates that military scientist should take better care of the cyborg's armors are more resistant to mechanical presure.|n With a jump, you impale your foe with your blade, cutting the thread of its function.|n|n|n|n|n>
	wait <Press any key to continue>
	foreground <yellow>
	msg < Blinding lights...|n|n|n What is this place?...|n|n|n A hospital?...|n|n|n A lab?...|n|n|n Heaven?...|n|n|n Hell?...|n|n|n You don't know and you can't tell for sure. You only know that you are on a stretcher being pushed in a corridor lit by lights... bright lights... very bright lights...|n Your whole body aches... you can't feel your legs... You can barely feel your arms... Your larygx aches as if an elastic tube was shoved in it...|n|n As you try to find what it is going on, you fade again... Fade back to your dream of the past... To the past that brought you here.|n|n|n>
	wait <Press any key to continue.>
	foreground <black>
	msg <>
	goto <dark alley>
	
end define

define procedure <talkSabre>
	msg < You see that under the trenchcoat and the hat, hides Sabre, the leader of Alpha Force himself.>
	msg < The comrade in arms against crime greets you.|n In a hollow voice, he tells you: " Oh, nice to meet you comrade. We have learned you are a brave and capable avenger. I would propose you could work with us. As far as I can see, you hold a grudge against Tony Torenti. He is a very powerful criminal indeed, but at the moment our group has other priorities.But you could help us. We have gathered info on him. We know the location of his headquarters and the security systems, plus we have a plan to infiltrate them. Are you interested of doing this instead of us?">
	goto <control center>
	
end define

define procedure <vitrues>
	if ( vitrue = Honour ) or ( vitrue = honour ) or ( vitrue = Valour ) or ( vitrue = valour ) or ( vitrue = Justice ) or ( vitrue = justice ) or ( vitrue = Compassion ) or ( vitrue = compassion ) or ( vitrue = strength ) or ( vitrue = Strength ) then msg < The button clicks as you press it.>
	if ( vitrue = all ) then create exit south <Gate; Castle>
end define

define procedure <statue>
	displaytext <dialogue>
	goto <Surgery (on table)>
	
end define

define text <intro>
Total darkness...

Or something like that...

You, in foetal position, tied to tubes and millions of high-tech machines, an artificial womb made to sustain your dying body. The only move you can do is to blink. All you can distinguish beyond the green thick liquid that surrounds you, are some shades. Probably scientists watching over your progress. That is  what happens when you are Blade Sentinel, the well-known superhero.


But things were not allways like that (What a cliche, you say to yourself). It all changed in one day... A day not so far away from this one...




end define

define text <win>
You gather the last of your power, as you arise to ring the alarm. You barely make it, hitting the button and setting the alarm on. Torrenti smiles evily, as he sadistically shoot you in the left shoulder. The pain is intorable. Blood springs from the wound and you feel like going into another coma. Then Torenti raises the gun, touching it to your forehead. You now it is time to die. Images of your past life pass in front o your eyes.
But the door opens and RockHard rushes into the room. Torrenti freezes and so does the huge avenger. And then Vixen and The Crusader enter the room, both hurt by your previous encounters. Sabre enters too, and so do other members.
Torrenti is frozen. Sabre frozen too. It is time for you to speak. You utter: "Sabre... betrayed... you..." and cough. Sabre tries to explain the unexplainable, but RockHard stops his attempt with a demolishing punch, senting him through a wall. Then grabs Torrenti. Then you fade out.

You wake up in the familiar surgury. This time Vixen and RockHard are by your side. Vixen talks to you, apologising for all that happened. She tells Alpha Force would be glad to work with you. When you ask about Sabre and Torrenti, she tells you:" We decided to send them to Torrenti's friends with a note about their plan."



SOMEWHERE ELSE:

Torrenti: NO!!! You can't do this. We were allies... friends...
Mobster: You betrayed us and you will get what you diserve, Tony!
Torrenti: NOOOOO!!!!!!!!!!!!!!!!!!!!!!
end define

define text <lose>

end define

define text <Alpha>
The newspaper has an article about the Alpha Force.
The article is like that:
"In the few past months, a group of Vigillantes, naming themselves the "Alpha Force" are cleansing the streets of our city of the criminals. Their work has made the life of citisents much safer. The city owes a big debt to this outstanding group of braved masked crime avengers.
The leader of this group is "Sabre", a man in a red suit, known for his extreme agility and the sword he uses. Another notorius member of the team is "The Crusader", a man whose uniform is full of crosses. In an interview he gave us recently, he admits he fights crimes because of his faith to God. Criminals fear the blasts this holy avenger shoots from the devices attached to his hands. And who hasn't heard of "RockHard", the mountain of muscles of the team. Even though many doubt he has the brains, the rest of the group members saim it isn't true. Since there is  equality of the sexes, we should mention "Vixen", a black clad lady with a love for throwing knives. Another important member is..."
(The rest of the article is unreadable, because some coffee is spilled on the newspaper.)
end define

define text <transform>
As you reach for the hilt, the droid makes its move: Its mighty bionic arms come down, crushing the floor. Thanks to your reflexes you are still alive. But the hilt bounces outside of your reach. As you crawl for it,the droid raises its fists for the finishing strike. You look at it as you blindly stumble for the hilt... You know your end comes closer every instant passing. Your dreaded enemy launches against you once more, while you touch, then grasp the hilt.
Primordial energy runs through your palm, arm, your entire body. Pure force fills your heart with courrage. Courrage to fight your rival. From the hilt extends a blade of force. The same force that creates a light, flexible, almost elastic, yet extremely endurable and hard armor. You feel stronger both physically and emotionally. You are puzzled at what is happening to you, but there are many more important things to thing about now. Like the leathal fist that's heading to your head.


end define

define text <warehouse>













The Shark is going to pay for that, you say to yourself, as you watch the warehouse from above. The city is silent tonight. Or is it just you? No time for thinking, the time for action has come. Law won't protect the citizents. You would never admit it before, but deep inside, the back side of your head, you always knew it. Now it is time for some Justice to be done.
Alice Morgan  would never act like that, but the Blade Sentinel will. The Blade told you so. "I am here to help you bring Justice. I've chosen you to.". You give it another look to the Blade and take the courage to take the law to your hands. As you slide down the wall and gently land to the deserted street in the docks area, you can't stop but remembering the look (if you can call it that way) of the droid, as you choped off it's arm.
end define

define text <lab2>














Back to your artificial womb, you linger in a state between life and death, consiousness and trance, past and present...
The world around you comes and goes, constantly coming, then again fading away...
The robes are hear talking to eachother. You can figure some words: "danger... stabilise... death... live...".
Soon the world around you fades away once more, sending you once more in the sweet, yet fatal torpor of unconsiousness.
end define

define text <dialogue>
As you reach for the statue, the birds on the fountain fly away. The noise they make break the silent air. The knight is an impressive figure, wearing a heavy armor and wielding a longsword. As you look closer, you realise that it looks much alike the Blade.
Suddenly a tap on your shoulder shocks you. You turn around, ready for a fight, when you realise it was a friendly man. The statue knight is before you in flesh and blood (And the metal of his armor). He wields the Blade in his right hand.
You try to speak, but you find your self at a loss for words. The man raises his eyes, your eyes looking at his. He speaks at you, his voice is clear and gentle:
- Wellcome Alice. Don't be afraid.
- Who are you? And what is this place?
- This... This is your subconsius... And I am your guide.
- My guide to what?
He stares at you for a moment, then answers.
- Your guide to your duty... Your duty as the Blade Sentinel.
- You sent me the Blade?
- The Blade sent itself to you. It allways chooses a champion to defend rightiousness. One at every age. You are a worthy champion. You just proved you have the wisdom to serve the Blade well. And now, you must go back and do what you have to do.
- But... But I have lost the Blade. How should I find it? And I am wounded. I stand no chance...
- You lost the hilt, not the Blade. The hilt is the focus. YOU are the Blade. Go back and do what you must. Now take this!
As he gives you the Blade, everything dims once more.


end define

define text <boom>
As you read the message, you realise that this was a trap. You run to get away, but it is too late. Explosives soon detonate, making the building a Hell on Earth. The building collapses on you, and everything blackens around you.













end define

define text <wake>
You creak your eyes. You can hear a voice. It says: "The hilt is lost. She is useless. Give her this injection we talked about."




end define

define text <garden>
Enter text here...
end define

define selection <talkJim>
	info <What would you like to tell him?>
	choice < Good morning Jim. Is everything alright?> msg < Wish it was! Tony Torenti, the "Shark" was released today. The attorney dropped all charges against him.>
	choice <What's up? Any problems with the kids?> msg < No, no, it's nothing wrong with them. I'm just worried about you! The "Shark" is free. The atorney dropped all the charges against him.>
	choice <Is it my imagination, or is it really something bothering you?> msg < Wish it was MY imagination and Tony Torenti wasn't reliesed!>
end define
define selection <computer>
	info <The computer contains:>
	choice <The droid behaviour program> if real <aggr> then msg < The "party" is going to start soon. You don't want to crush it...> else {
		property <Skippy's computer; aggr=true>
		msg < You set the droids to aggressive mode and can't wait to get the party started.>
		goto <Outside Torenti's office>
	}
	choice <Quake 3> msg < You don't have time for games.>
	choice <A porn movie> if not property <Skippy's computer; aggr=true> then msg < No time for that too.> else {
		msg < As the movie goes, your friend from outside listens and says: "Hey Skippy, sorry to interupt. See you tommorow">
		goto <Outside Torenti's office>
	}
end define
define selection <knight>
end define
define selection <talkTorrenti>
	info <What would you like to say to Torrenti>
	choice <What the Hell are you doing in here?> {
		msg < My dear, he replies with an evil grin, don't you get it? I CONTROL these goons. I pay their expenses. They do my job. Destroy my rivals. Thanks to my boy, Sabre.>
		choose <talkTorrenti>
	}
	choice <You are behind all these, but why did your boys gave me the way in your headquarters?> {
		msg < Simple, miss Morgan. I thought you would have got it by now... I had to fake my death and rule from the shadows. And you my dear, were a problem. So I would kill you too. Don't you think this could be a great accomplishment?>
		choose <talkTorrenti>
	}
	choice <You deserve to die, creep!> msg < Really? Oh, well, maybe another time. Because now YOU are going to die.>
end define

